
<?php $__env->startSection('panel'); ?>
    <section>
        <div class="card mb-4">
            <div class="card-header">
                <h4 class="card-title"><?php echo e(translate('Email Logs')); ?></h4>
            </div>

            <div class="card-filter">
                <form action="<?php echo e(route('admin.email.search')); ?>" method="GET">
                    <div class="filter-form">
                        <div class="filter-item">
                            <select name="status" class="form-control">
                                <option value="all" <?php if(@$status == "all"): ?> selected <?php endif; ?>><?php echo e(translate('All')); ?></option>
                                <option value="pending" <?php if(@$status == "pending"): ?> selected <?php endif; ?>><?php echo e(translate('Pending')); ?></option>
                                <option value="schedule" <?php if(@$status == "schedule"): ?> selected <?php endif; ?>><?php echo e(translate('Schedule')); ?></option>
                                <option value="fail" <?php if(@$status == "fail"): ?> selected <?php endif; ?>><?php echo e(translate('Fail')); ?></option>
                                <option value="delivered" <?php if(@$status == "delivered"): ?> selected <?php endif; ?>><?php echo e(translate('Delivered')); ?></option>
                            </select>
                        </div>

                        <div class="filter-item">
                            <input type="text" autocomplete="off" name="search" placeholder="<?php echo e(translate('Search with User, Email or To Recipient Number')); ?>" class="form-control" id="search" value="<?php echo e(@$search); ?>">
                        </div>

                        <div class="filter-item">
                            <input type="text" class="form-control datepicker-here" name="date" value="<?php echo e(@$searchDate); ?>" data-range="true" data-multiple-dates-separator=" - " data-language="en" data-position="bottom right" autocomplete="off" placeholder="<?php echo e(translate('From Date-To Date')); ?>" id="date">
                        </div>

                        <div class="filter-action">
                            <button class="i-btn primary--btn btn--md" type="submit">
                                <i class="fas fa-search"></i> <?php echo e(translate('Search')); ?>

                            </button>
                            <button class="i-btn danger--btn btn--md">
                                <a class="text-white" href="<?php echo e(route('admin.email.index')); ?>">
                                    <i class="las la-sync"></i>  <?php echo e(translate('reset')); ?>

                                </a>
                            </button>

                            <div class="statusUpdateBtn d-none">
                                <a class="i-btn success--btn btn--md statusupdate"
                                   data-bs-toggle="tooltip"
                                   data-bs-placement="top" title="Status Update"
                                   data-bs-toggle="modal"
                                   data-bs-target="#smsstatusupdate"
                                   type="submit">
                                    <i class="fas fa-gear"></i> <?php echo e(translate('Action')); ?>

                                </a>
                            </div>
                        </div>


                    </div>
                </form>
            </div>

            <div class="card-body px-0">
                <div class="responsive-table">
                    <table>
                        <thead>
                            <tr>
                                <th>
                                    <div class="d-flex align-items-center">
                                        <input class="form-check-input mt-0 me-2 checkAll"
                                           type="checkbox"
                                           value=""
                                           aria-label="Checkbox for following text input"> <span>#</span>
                                    </div>
                                </th>
                                <th> <?php echo e(translate('User')); ?></th>
                                <th> <?php echo e(translate('Sender')); ?></th>
                                <th> <?php echo e(translate('To')); ?></th>
                                <th> <?php echo e(translate('Subject')); ?></th>
                                <th> <?php echo e(translate('Initiated')); ?></th>
                                <th><?php echo e(translate('Schedule')); ?></th>
                                <th> <?php echo e(translate('Status')); ?></th>
                                <th> <?php echo e(translate('Action')); ?></th>
                            </tr>
                        </thead>
                        <?php $__empty_1 = true; $__currentLoopData = $emailLogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $emailLog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr class="<?php if($loop->even): ?><?php endif; ?>">
                                <td class="d-none d-md-flex align-items-center">
                                    <input class="form-check-input mt-0 me-2" type="checkbox" name="emaillog" value="<?php echo e($emailLog->id); ?>" aria-label="Checkbox for following text input">
                                    <?php echo e($loop->iteration); ?>

                                </td>

                                 <td data-label=" <?php echo e(translate('User')); ?>">
                                    <?php if($emailLog->user_id): ?>
                                        <a href="<?php echo e(route('admin.user.details', $emailLog->user_id)); ?>" class="fw-bold text-dark"><?php echo e($emailLog->user?->name); ?></a>
                                    <?php else: ?>
                                        <span> <?php echo e(translate('Admin')); ?></span>
                                    <?php endif; ?>
                                </td>

                                <td data-label=" <?php echo e(translate('Sender')); ?>">
                                    <span class="text--primary fw-bold"><?php echo e(ucfirst(@$emailLog->sender->name)); ?></span>
                                </td>

                                <td data-label=" <?php echo e(translate('To')); ?>">
                                    <?php echo e($emailLog->to); ?>

                                </td>

                                <td data-label=" <?php echo e(translate('Subject')); ?>">
                                    <?php echo e($emailLog->subject); ?>

                                </td>

                                <td data-label="<?php echo e(translate('Initiated')); ?>">
                                    <?php echo e(getDateTime($emailLog->created_at)); ?>

                                </td>

                                <td data-label="<?php echo e(translate('Schedule')); ?>">
                                    <?php if(!is_null($emailLog->initiated_time)): ?>
                                        <?php echo e(getDateTime($emailLog->initiated_time)); ?>

                                    <?php else: ?>
                                        <span><?php echo e(translate('N/A')); ?></span>
                                    <?php endif; ?>
                                </td>

                                <td data-label=" <?php echo e(translate('Status')); ?>">
                                    <?php if($emailLog->status == 1): ?>
                                        <span class="badge badge--primary"> <?php echo e(translate('Pending ')); ?></span>
                                    <?php elseif($emailLog->status == 2): ?>
                                        <span class="badge badge--info"> <?php echo e(translate('Schedule')); ?></span>
                                    <?php elseif($emailLog->status == 3): ?>
                                        <span class="badge badge--danger"> <?php echo e(translate('Fail')); ?></span>
                                    <?php else: ?>
                                        <span class="badge badge--success"> <?php echo e(translate('Delivered')); ?></span>
                                    <?php endif; ?>
                                    <a class="s_btn--coral text--light statusupdate"
                                        data-id="<?php echo e($emailLog->id); ?>"
                                        data-bs-toggle="tooltip"
                                        data-bs-placement="top" title="Status Update"
                                        data-bs-target="#smsstatusupdate"
                                        ><i class="las la-info-circle"></i></a>
                                </td>

                                <td data-label=" <?php echo e(translate('Action')); ?>">
                                    <div class="d-flex align-items-center justify-content-md-start justify-content-end gap-3">
                                        <?php if($emailLog->status == 1 ||$emailLog->status == 3): ?>
                                            <a href="<?php echo e(route('admin.email.single.mail.send', $emailLog->id)); ?>" class="i-btn warning--btn btn--sm" data-bs-toggle="tooltip" data-bs-placement="top" title="Resend" ><i class="las la-paper-plane"></i></a>
                                        <?php endif; ?>
                                        <a class="i-btn primary--btn btn--sm" href="<?php echo e(route('admin.email.view',$emailLog->id)); ?>" target="_blank"
                                            ><i class="las la-desktop"></i></a>

                                        <a href="javascript:void(0)" class="i-btn danger--btn btn--sm emaildelete"
                                            data-bs-toggle="modal"
                                            data-bs-target="#delete"
                                            data-delete_id="<?php echo e($emailLog->id); ?>"
                                            ><i class="las la-trash"></i>
                                        </a>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td class="text-muted text-center" colspan="100%"> <?php echo e(translate('No Data Found')); ?></td>
                            </tr>
                        <?php endif; ?>
                    </table>
                </div>
                <div class="m-3">
                    <?php echo e($emailLogs->appends(request()->all())->onEachSide(1)->links()); ?>

                </div>
            </div>
        </div>
    </section>

    <div class="modal fade" id="smsstatusupdate" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <form action="<?php echo e(route('admin.email.status.update')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="id">
                    <input type="hidden" name="email_log_id">
                    <div class="modal-body">
                        <div class="card">
                            <div class="card-header bg--lite--violet">
                                <div class="card-title text-center text--light"> <?php echo e(translate('Email Status Update')); ?></div>
                            </div>
                            <div class="card-body">
                                <div class="mb-3">
                                    <label for="status" class="form-label"> <?php echo e(translate('Status')); ?> <sup class="text--danger">*</sup></label>
                                    <select class="form-control" name="status" id="status" required>
                                        <option value="" selected disabled> <?php echo e(translate('Select Status')); ?></option>
                                        <option value="1"> <?php echo e(translate('Pending')); ?></option>
                                        <option value="4"> <?php echo e(translate('Success')); ?></option>
                                        <option value="3"> <?php echo e(translate('Fail')); ?></option>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="modal_button2 modal-footer">
                        <div class="d-flex align-items-center justify-content-center gap-3">
                            <button type="button" class="i-btn primary--btn btn--md" data-bs-dismiss="modal"> <?php echo e(translate('Cancel')); ?></button>
                            <button type="submit" class="i-btn success--btn btn--md"> <?php echo e(translate('Submit')); ?></button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>


    <div class="modal fade" id="smsdetails" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-body">
                    <div class="card">
                        <div class="card-header bg--lite--violet">
                            <div class="card-title text-center text--light"> <?php echo e(translate('Message')); ?></div>
                        </div>
                        <div class="card-body mb-3">
                            <p id="message--text"></p>
                        </div>
                    </div>
                </div>

                <div class="modal_button2 modal-footer">
                    <div class="d-flex align-items-center justify-content-center gap-3">
                        <button type="button" class="i-btn primary--btn btn--md" data-bs-dismiss="modal"> <?php echo e(translate('Cancel')); ?></button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="delete" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <form action="<?php echo e(route('admin.email.delete')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="id" value="">
                    <div class="modal_body2">
                        <div class="modal_icon2">
                            <i class="las la-trash"></i>
                        </div>
                        <div class="modal_text2 mt-3">
                            <h6> <?php echo e(translate('Are you sure to delete this email from log')); ?></h6>
                        </div>
                    </div>
                    <div class="modal_button2 modal-footer">
                        <div class="d-flex align-items-center justify-content-center gap-3">
                            <button type="button" class="i-btn primary--btn btn--md" data-bs-dismiss="modal"> <?php echo e(translate('Cancel')); ?></button>
                            <button type="submit" class="i-btn danger--btn btn--md"> <?php echo e(translate('Delete')); ?></button>
                        </div>

                    </div>
                </form>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>


<?php $__env->startPush('script-push'); ?>
<script>
	(function($){
		"use strict";
		$('.statusupdate').on('click', function(){
			var modal = $('#smsstatusupdate');
			modal.find('input[name=id]').val($(this).data('id'));
			modal.modal('show');
		});

		$('.emaildelete').on('click', function(){
			var modal = $('#delete');
			modal.find('input[name=id]').val($(this).data('delete_id'));
			modal.modal('show');
		});

        $('.checkAll').click(function(){
            $('input:checkbox').not(this).prop('checked', this.checked);
        });

        $('.statusupdate').on('click', function(){
            var modal = $('#smsstatusupdate');
            var newArray = [];
            $("input:checkbox[name=emaillog]:checked").each(function(){
                newArray.push($(this).val());
            });
            modal.find('input[name=email_log_id]').val(newArray.join(','));
            modal.modal('show');
        });
	})(jQuery);
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\laragon\www\xsender\src\resources\views/admin/email/index.blade.php ENDPATH**/ ?>