
<?php $__env->startSection('panel'); ?>
<section>
   
    <div class="container-fluid p-0">
        <div class="row gy-4">
            <?php echo $__env->make('admin.sms_gateway.sms_gateway_tab', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <div class="col">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title"> <?php echo e(translate('SMS Gateway List')); ?></h4>
                    </div>

                    <div class="card-body px-0">
                        <div class="responsive-table">
                            <table>
                                <thead>
                                <tr>
                                    <th><?php echo e(translate('Gateway Name')); ?></th>
                                    <th><?php echo e(translate('Gateway Type')); ?></th>
                                    <th><?php echo e(translate('Default')); ?></th>
                                    <th><?php echo e(translate('Status')); ?></th>
                                    <th><?php echo e(translate('Action')); ?></th>
                                </tr>
                                </thead>
                                <?php $__empty_1 = true; $__currentLoopData = $smsGateways; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $smsGateway): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <?php 
                                        $driver_info = json_encode($smsGateway->sms_gateways);
                                    ?>
                                    <tr class="<?php if($loop->even): ?><?php endif; ?>">
                                        
                                        <td data-label="<?php echo e(translate('Gateway Name')); ?>"><span class="text-dark"><?php echo e(ucfirst($smsGateway->name)); ?></span></td>
                                        <td data-label="<?php echo e(translate('Gateway Type')); ?>"><span class="text-dark"><?php echo e(preg_replace('/[[:digit:]]/','', setInputLabel($smsGateway->type))); ?></span></td>
                                        <td class="text-center" data-label="<?php echo e(translate('Default')); ?>">
                                            <div class="d-flex justify-content-md-start justify-content-end">
                                                <?php if($smsGateway?->is_default == 1): ?>
                                                    <i class="las la-check-double text--success" style="font-size:32px"></i>
                                                <?php else: ?>
                                                    <label class="switch">
                                                        <input type="checkbox" class="default_status" data-id="<?php echo e($smsGateway->id); ?>" value="1" name="default_value" id="default_gateway">
                                                        <span class="slider"></span>
                                                    </label>
                                                <?php endif; ?>
                                            </div>
                                        </td>
                                        <td data-label="<?php echo e(translate('Status')); ?>">
                                            <?php if($smsGateway->status == 1): ?>
                                                <span class="badge badge--success"><?php echo e(translate('Active')); ?></span>
                                            <?php else: ?>
                                                <span class="badge badge--danger"><?php echo e(translate('Inactive')); ?></span>
                                            <?php endif; ?>
                                        </td>

                                        <td data-label="<?php echo e(translate('Action')); ?>">
                                            <div class="d-flex align-items-center justify-content-md-start justify-content-end gap-3">
                                                <a class="i-btn info--btn btn--sm gateway-details"
                                                    data-sms_credentials="<?php echo e($driver_info); ?>"
                                                    data-bs-placement="top" title="Gateway Information"
                                                    data-bs-toggle="modal"
                                                    data-bs-target="#gatewayInfo">
                                                    <i class="las la-info-circle"></i>
                                                </a>    
                                                <a href="javascript:void(0)" class="i-btn success--btn btn--sm edit-gateway" 
                                                    data-bs-toggle="modal"
                                                    data-bs-target="#editgateway"
                                                    data-id="<?php echo e($smsGateway?->id); ?>"
                                                    data-gateway_type="<?php echo e($smsGateway?->type); ?>"
                                                    data-gateway_name="<?php echo e($smsGateway?->name); ?>"
                                                    data-gateway_credentials="<?php echo e(json_encode($smsGateway?->sms_gateways)); ?>"
                                                    data-gateway_status="<?php echo e($smsGateway?->status); ?>">
                                                    <i class="las la-pen"></i>
                                                </a>
            
                                                <a href="javascript:void(0)" class="i-btn danger--btn btn--sm delete"
                                                    data-bs-toggle="modal"
                                                    data-bs-target="#gatewayDelete"
                                                    data-delete_id="<?php echo e($smsGateway->id); ?>"
                                                    ><i class="las la-trash"></i>
                                                </a>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%"><?php echo e(translate('No Data Found')); ?></td>
                                    </tr>
                                <?php endif; ?>
                            </table>
                        </div>

                        <div class="m-3">
                            <?php echo e($smsGateways->appends(request()->all())->onEachSide(1)->links()); ?>

                        </div>
                    </div>
                </div>
                <a href="javascript:void(0);" class="support-ticket-float-btn" data-bs-toggle="modal" data-bs-target="#addgateway" title=" <?php echo e(translate('Add New Gateway')); ?>">
                    <i class="fa fa-plus ticket-float"></i>
                </a>
            </div>
        </div>
    </div>
</section>



<div class="modal fade" id="gatewayInfo" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog nafiz">
        <div class="modal-content">
            <div class="modal-body">
                <div class="card">
                    <div class="card-header bg--lite--violet">
                        <div class="card-title text-center text--light"><?php echo e(translate('Gateway Information')); ?></div>
                    </div>
                    <div class="card-body">
                        <div class="driver-info"></div>
                    </div>
                </div>
            </div>

            <div class="modal_button2 modal-footer">
                <div class="d-flex align-items-center justify-content-center gap-3">
                    <button type="button" class="i-btn primary--btn btn--md" data-bs-dismiss="modal"><?php echo e(translate('Close')); ?></button>
                </div>
            </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="gatewayDelete" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
        	<form action="<?php echo e(route('admin.sms.gateway.delete')); ?>" method="GET">
        		<?php echo csrf_field(); ?>
        		<input type="hidden" name="id" value="">
	            <div class="modal_body2">
	                <div class="modal_icon2">
	                    <i class="las la-trash"></i>
	                </div>
	                <div class="modal_text2 mt-4">
	                    <h5><?php echo e(translate('Are you sure to delete this gateway')); ?></h5>
	                </div>
	            </div>

				<div class="modal_button2 modal-footer">
					<div class="d-flex align-items-center justify-content-center gap-3">
						<button type="button" class="i-btn danger--btn btn--md" data-bs-dismiss="modal"><?php echo e(translate('Cancel')); ?></button>
						<button type="submit" class="i-btn primary--btn btn--md"><?php echo e(translate('Delete')); ?></button>
					</div>
				</div>
	        </form>
        </div>
    </div>
</div>

<div class="modal fade" id="editgateway" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><?php echo e(translate('Edit SMS Gateway')); ?></h5>
                <button type="button" class="i-btn bg--lite--danger text--danger btn--sm" data-bs-dismiss="modal"> <i class="las la-times"></i></button>
            </div>

            <form action="<?php echo e(route('admin.sms.gateway.update')); ?>" method="post">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="id" value="">
                <div class="modal-body">
                    <div class="card">
                        <div class="card-body">
                            <div class="form-item mb-3">
                                <label for="name" class="form-label"> <?php echo e(translate('From Name')); ?> <sup class="text--danger">*</sup></label>
                                <input type="text" class="form-control" id="name" name="name" placeholder=" <?php echo e(translate('Enter From Name')); ?>" required>
                            </div>

                            <div class="form-item mb-3">
                                <label for="gateway_type_edit" class="form-label"> <?php echo e(translate('Gateway Type')); ?> <sup class="text--danger">*</sup></label>
                                <select class="form-select text-uppercase select-gateway-type gateway_type" name="type" required="" id="gateway_type_edit"></select> 
                            </div>
                            
                            <div class="row mb-3 newdataadd"></div>
                            <div class="row mb-3 oldData"></div>

                            <div class="form-item mb-3">
                                <label for="status" class="form-label"> <?php echo e(translate('Status')); ?> <sup class="text--danger">*</sup></label>
                                <select class="form-select" name="status" id="status" required>
                                    <option class="active" value="1"> <?php echo e(translate('Active')); ?></option>
                                    <option class="inactive" value="0"> <?php echo e(translate('Inactive')); ?></option>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="modal-footer">
                    <div class="d-flex align-items-center gap-3">
                        <button type="button" class="i-btn danger--btn btn--md" data-bs-dismiss="modal"> <?php echo e(translate('Cancel')); ?></button>
                        <button type="submit" class="i-btn primary--btn btn--md"> <?php echo e(translate('Submit')); ?></button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="addgateway" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><?php echo e(translate('Add SMS Gateway')); ?></h5>
                <button type="button" class="i-btn bg--lite--danger text--danger btn--sm" data-bs-dismiss="modal"> <i class="las la-times"></i></button>
            </div>

            <form action="<?php echo e(route('admin.sms.gateway.create')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <div class="modal-body">
                    <div class="card">
                        <div class="card-body">
                            
                            <div class="form-item mb-3">
                                <label for="name" class="form-label"> <?php echo e(translate('Gateway Name')); ?> <sup class="text--danger">*</sup></label>
                                <input type="text" class="form-control" id="name" name="name" placeholder=" <?php echo e(translate('Gateway Name')); ?>" required>
                            </div>
                           
                            <div class="form-item mb-3">
                                <label for="add_gateway_type" class="form-label"> <?php echo e(translate('Gateway Type')); ?> <sup class="text--danger">*</sup></label>
                                <select class="form-select gateway_type" name="type" required="" id="add_gateway_type">
                                    <option value=""selected disabled><?php echo e(translate("Select a gateway type")); ?></option>
                                    <?php $__currentLoopData = $credentials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $credential): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($credential->gateway_code); ?>"><?php echo e(strtoupper($credential->name)); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                          
                            <div class="row mb-3 newdataadd"></div>
                         
                      
                        
                            <div class="form-item mb-3">
                                <label for="status" class="form-label"> <?php echo e(translate('Status')); ?> <sup class="text--danger">*</sup></label>
                                <select class="form-select" name="status" id="status" required>
                                    <option value="1"> <?php echo e(translate('Active')); ?></option>
                                    <option value="0"> <?php echo e(translate('Inactive')); ?></option>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="modal-footer">
                    <div class="d-flex align-items-center gap-3">
                        <button type="button" class="i-btn danger--btn btn--md" data-bs-dismiss="modal"> <?php echo e(translate('Cancel')); ?></button>
                        <button type="submit" class="i-btn primary--btn btn--md"> <?php echo e(translate('Submit')); ?></button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script-push'); ?>
    <script>
        (function($){
            "use strict";
            var oldType = '';
            var oldInfo = [];

            $('.gateway-details').on('click', function(){
                $('.driver-info').empty();
                var modal = $('#gatewayInfo');
                var driver = $(this).data('sms_credentials');
                $.each(driver, function(key, value) {
                  var paragraph = $('<p class="d-flex justify-content-start align-items-center "><span class="fw-bold text-capitalize col-4">' + key + ' </span> <span class="col-8">: ' + value + ' </span></p>');
                  $('.driver-info').append(paragraph);
              });
                modal.modal('show');
            });

            $('.delete').on('click', function(){

                var modal = $('#gatewayDelete');
                modal.find('input[name=id]').val($(this).data('delete_id'));
                modal.modal('show');
            });

            $('.edit-gateway').on('click', function() {

                $('.newdataadd').empty();
                $('.oldData').empty();
                $('.select-gateway-type').empty();
                $('.active').attr("selected",false);
                $('.inactive').attr("selected",false);
                $('.gatewayType').attr("selected",false);
                
                var modal = $('#editgateway');
                modal.find('input[name=id]').val($(this).data('id'));
                modal.find('input[name=name]').val($(this).data('gateway_name'));
                $(this).data('gateway_status') == 1 ? $('.active').attr("selected",true) : $('.inactive').attr("selected",true);

                
                var data = <?php echo $credentials ?>;
                oldType = $(this).data('gateway_type');
                
                $.each(data, function(key, value) {
                    var gateway = value['gateway_code'].replace(value['gateway_code'].match(/(\d+)/g)[0], '').trim(); 
                    var option = $('<option class="text-uppercase gatewayType" value="'+ value['gateway_code'] +'">'+ gateway +'</option>');
                    $('.select-gateway-type').append(option);
                    if(oldType == value['gateway_code']){
                        $('.gatewayType').attr("selected",true)
                    }
                });

                oldInfo = $(this).data('gateway_credentials');
                
                $.each(oldInfo, function(key, value) {
                    var filterkey = key.replace("_", " ");
                    var div   = $('<div class="form-item mb-3 col-lg-6"></div>');
                    var label = $('<label for="' + key + '" class="form-label text-capitalize">' + filterkey + '<sup class="text--danger">*</sup></label>');
                    var input = $('<input type="text" class="form-control" id="' + key + '" value="' + value + '" name="driver_information[' + key + ']" placeholder="Enter ' + filterkey + '" required>');
                    div.append(label, input);
                    $('.oldData').append(div);
                });

                modal.modal('show');
            });

            $('.default_status').on('change', function(){
                
                const default_value = $(this).val();
                const id = $(this).attr('data-id');
                $.ajax({
                    method:'get',
                    url: "<?php echo e(route('admin.sms.gateway.default.status')); ?>",
                    headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
                    data:{
                    'default_value' : default_value,
                    'id' :id
                    },
                    dataType: 'json'
                }).then(response => {
                    if(response.status){
                        notify('success', 'Recommended Status Updated Successfully');
                        window.location.reload()
                    }
                    else{
                        notify('error', 'Inactive gateway can not be the default gateway');
                        window.location.reload()
                    }
                })


		    });
            $('.gateway_type').on('change', function() {
               
                $('.newdataadd').empty();
                var data = <?php echo $credentials ?>;
                var newType = this.value;
                
                if(newType != oldType){
                    
                    $.each(data, function(key, v) { 
                        $('.oldData').empty();
                        if(v['gateway_code'] == newType) {

                        var creds = v['credential'];
                        $.each(creds, function(key, v) {

                           
                                var filterkey = key.replace("_", " ");
                                var div   = $('<div class="form-item mb-3 col-lg-6"></div>');
                                var label = $('<label for="' + key + '" class="form-label text-capitalize">' + filterkey + '<sup class="text--danger">*</sup></label>');
                                var input = $('<input type="text" class="form-control" id="' + key + '" name="driver_information[' + key + ']" placeholder="Enter ' + filterkey + '" required>');
                                div.append(label, input);
                                $('.newdataadd').append(div);
                            });
                        }
                    });
                }
                else{
              
                    $.each(oldInfo, function(key, value) {
                        var filterkey = key.replace("_", " ");
                        var div   = $('<div class="form-item mb-3 col-lg-6"></div>');
                        var label = $('<label for="' + key + '" class="form-label text-capitalize">' + filterkey + '<sup class="text--danger">*</sup></label>');
                        var input = $('<input type="text" class="form-control" id="' + key + '" value="' + value + '" name="driver_information[' + key + ']" placeholder="Enter ' + filterkey + '" required>');
                        div.append(label, input);
                        $('.oldData').append(div);
                    });
                }
            });
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\laragon\www\xsender\src\resources\views/admin/sms_gateway/tabs/sms_api.blade.php ENDPATH**/ ?>