
<?php $__env->startSection('panel'); ?>
<section>
    <div class="container-fluid p-0">
        <div class="row gy-4">
            <?php echo $__env->make('admin.sms_gateway.sms_gateway_tab', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <div class="col">
                <div>
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title"> <?php echo e(translate('Android Gateway List')); ?></h4>
                        </div>
                        <div class="card-body px-0">
                            <div class="responsive-table">
                                <table >
                                    <thead>
                                    <tr>
                                        <th><?php echo e(translate('Name')); ?></th>
                                        <th><?php echo e(translate('Password')); ?></th>
                                        <th><?php echo e(translate('Status')); ?></th>
                                        <th><?php echo e(translate('SIM List')); ?></th>
                                        <th><?php echo e(translate('Action')); ?></th>
                                    </tr>
                                    </thead>
                                    <?php $__empty_1 = true; $__currentLoopData = $androids; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $android): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <tr class="<?php if($loop->even): ?><?php endif; ?>">
                                            <td data-label="<?php echo e(translate('Name')); ?>">
                                                <span class="text-dark"><?php echo e($android->name); ?></span>
                                            </td>

                                            <td data-label="<?php echo e(translate('Password')); ?>">
                                                <span class="text-dark"><?php echo e($android->show_password); ?></span>
                                            </td>

                                            <td data-label="<?php echo e(translate('Status')); ?>">
                                                <?php if($android->status == 1): ?>
                                                    <span class="badge badge--success"><?php echo e(translate('Active')); ?></span>
                                                <?php else: ?>
                                                    <span class="badge badge--danger"><?php echo e(translate('Inactive')); ?></span>
                                                <?php endif; ?>
                                            </td>

                                            <td data-label="<?php echo e(translate('list')); ?>">
                                                <a href="<?php echo e(route('admin.sms.gateway.android.sim.index', $android->id)); ?>" class="badge badge--primary p-2"><?php echo e(translate('View All')); ?></a>
                                            </td>

                                            <td data-label=<?php echo e(translate('Action')); ?>>
                                                <div class="d-flex align-items-center justify-content-md-start justify-content-end gap-3">
                                                    <a class="i-btn info--btn btn--sm android" data-bs-toggle="modal" data-bs-target="#updateandroid" href="javascript:void(0)"
                                                    data-id="<?php echo e($android->id); ?>"
                                                    data-name="<?php echo e($android->name); ?>"
                                                    data-password="<?php echo e($android->show_password); ?>"
                                                    data-status="<?php echo e($android->status); ?>"><i class="las la-pen"></i></a>
                                                <a class="i-btn danger--btn btn--sm delete" data-bs-toggle="modal" data-bs-target="#deleteandroidApi" href="javascript:void(0)" data-id="<?php echo e($android->id); ?>"><i class="las la-trash"></i></a>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <tr>
                                            <td class="text-muted text-center" colspan="100%"><?php echo e(translate('No Data Found')); ?></td>
                                        </tr>
                                    <?php endif; ?>
                                </table>
                            </div>
                            <div class="m-3">
                                <?php echo e($androids->appends(request()->all())->onEachSide(1)->links()); ?>

                            </div>
                        </div>
                    </div>

                    <a href="javascript:void(0);" class="support-ticket-float-btn" data-bs-toggle="modal" data-bs-target="#createandroid" title="<?php echo e(translate('Create New Android GW')); ?>">
                        <i class="fa fa-plus ticket-float"></i>
                    </a>
                </div>


                <div class="modal fade" id="createandroid" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                    <div class="modal-dialog">
                        <div class="modal-content">
                            <form action="<?php echo e(route('admin.sms.gateway.android.store')); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                                <div class="modal-body">
                                    <div class="card">
                                        <div class="card-header bg--lite--violet">
                                            <div class="card-title text-center text--light"><?php echo e(translate('Add New Android Gateway')); ?></div>
                                        </div>
                                        <div class="card-body">
                                            <div class="mb-3">
                                                <label for="name" class="form-label"><?php echo e(translate('Name')); ?> <sup class="text--danger">*</sup></label>
                                                <input type="text" class="form-control" id="name" name="name" placeholder="<?php echo e(translate('Enter Name')); ?>" required>
                                            </div>

                                            <div class="mb-3">
                                                <label for="password" class="form-label"><?php echo e(translate('Password')); ?> <sup class="text--danger">*</sup></label>
                                                <input type="password" class="form-control" id="password" name="password" placeholder="<?php echo e(translate('Enter Password')); ?>" required>
                                            </div>

                                            <div class="mb-3">
                                                <label for="password_confirmation" class="form-label"><?php echo e(translate('Confirm Password')); ?> <sup class="text--danger">*</sup></label>
                                                <input type="password" class="form-control" id="password_confirmation" name="password_confirmation" placeholder="<?php echo e(translate('Confirm Password')); ?>" required>
                                            </div>

                                            <div class="mb-3">
                                                <label for="status" class="form-label"><?php echo e(translate('Status')); ?> <sup class="text--danger">*</sup></label>
                                                <select class="form-control" name="status" id="status" required>
                                                    <option value="1"><?php echo e(translate('Active')); ?></option>
                                                    <option value="2"><?php echo e(translate('Inactive')); ?></option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="modal_button2 modal-footer">
                                    <div class="d-flex align-items-center justify-content-center gap-3">
                                        <button type="button" class="i-btn primary--btn btn--md" data-bs-dismiss="modal"><?php echo e(translate('Cancel')); ?></button>
                                        <button type="submit" class="i-btn danger--btn btn--md"><?php echo e(translate('Submit')); ?></button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>

                <div class="modal fade" id="updateandroid" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                    <div class="modal-dialog">
                        <div class="modal-content">
                            <form action="<?php echo e(route('admin.sms.gateway.android.update')); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                                <input type="hidden" name="id">
                                <div class="modal-body">
                                    <div class="card">
                                        <div class="card-header bg--lite--violet">
                                            <div class="card-title text-center text--light"><?php echo e(translate('Update Android Gateway')); ?></div>
                                        </div>
                                        <div class="card-body">
                                            <div class="mb-3">
                                                <label for="name" class="form-label"><?php echo e(translate('Name')); ?><sup class="text--danger">*</sup></label>
                                                <input type="text" class="form-control" id="name" name="name" placeholder="<?php echo e(translate('Enter Name')); ?>" required>
                                            </div>

                                            <div class="mb-3">
                                                <label for="password" class="form-label"><?php echo e(translate('Password')); ?> <sup class="text--danger">*</sup></label>
                                                <input type="password" class="form-control" id="password" name="password" placeholder="<?php echo e(translate('Enter Password')); ?>" required>
                                            </div>

                                            <div class="mb-3">
                                                <label for="status" class="form-label"><?php echo e(translate('Status')); ?> <sup class="text--danger">*</sup></label>
                                                <select class="form-control" name="status" id="status" required>
                                                    <option value="1"><?php echo e(translate('Active')); ?></option>
                                                    <option value="2"><?php echo e(translate('Inactive')); ?></option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="modal_button2 modal-footer">
                                    <div class="d-flex align-items-center justify-content-center gap-3">
                                        <button type="button" class="i-btn primary--btn btn--md" data-bs-dismiss="modal"><?php echo e(translate('Cancel')); ?></button>
                                        <button type="submit" class="i-btn danger--btn btn--md"><?php echo e(translate('Submit')); ?></button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>


                <div class="modal fade" id="deleteandroidApi" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                    <div class="modal-dialog">
                        <div class="modal-content">
                            <form action="<?php echo e(route('admin.sms.gateway.android.delete')); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                                <input type="hidden" name="id">
                                <div class="modal_body2">
                                    <div class="modal_icon2">
                                        <i class="las la-trash"></i>
                                    </div>
                                    <div class="modal_text2 mt-3">
                                        <h6><?php echo e(translate('Are you sure to want delete this android gateway?')); ?></h6>
                                    </div>
                                </div>
                                <div class="modal_button2 modal-footer">
                                    <div class="d-flex align-items-center justify-content-center gap-3">
                                        <button type="button" class="i-btn primary--btn btn--md" data-bs-dismiss="modal"><?php echo e(translate('Cancel')); ?></button>
                                        <button type="submit" class="i-btn danger--btn btn--md"><?php echo e(translate('Delete')); ?></button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>


<?php $__env->stopSection(); ?>


<?php $__env->startPush('script-push'); ?>
    <script>
        (function($){
            "use strict";
            $('.android').on('click', function(){
                var modal = $('#updateandroid');
                modal.find('input[name=id]').val($(this).data('id'));
                modal.find('input[name=name]').val($(this).data('name'));
                modal.find('input[name=password]').val($(this).data('password'));
                modal.modal('show');
            });

            $('.delete').on('click', function(){
                var modal = $('#deleteandroidApi');
                modal.find('input[name=id]').val($(this).data('id'));
                modal.modal('show');
            });
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>


<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\laragon\www\xsender\src\resources\views/admin/sms_gateway/tabs/android.blade.php ENDPATH**/ ?>