
<?php $__env->startSection('panel'); ?>
<section>
    <div class="card">
        <div class="card-header">
            <h4 class="card-title"><?php echo e(translate('Send SMS')); ?></h4>
            <div  data-bs-toggle="tooltip" data-bs-placement="left" data-bs-title="Suggestions Note">
                <button class="i-btn info--btn btn--sm d-xl-none info-note-btn"><i class="las la-info-circle"></i></button>
            </div>
        </div>

        <div class="card-body position-relative">
            <form action="<?php echo e(route('admin.sms.store')); ?>" method="POST" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <div class="row g-4">
                    <div class="col-xl-9 order-xl-1 order-2">
                        <div class="form-wrapper">
                            <h6 class="form-wrapper-title"><?php echo e(translate('Set Target Audience')); ?></h6>

                            <div class="file-tab">
                                <ul class="nav nav-tabs mb-3 gap-2" id="myTabContent" role="tablist">
                                    <li class="nav-item single-audience" role="presentation">
                                        <button class="nav-link active" id="single-tab" data-bs-toggle="tab" data-bs-target="#single-tab-pane" type="button" role="tab" aria-controls="single-tab-pane" aria-selected="true"><i class="las la-user"></i> <?php echo e(translate('Single Audience')); ?></button>
                                    </li>
                                    <li class="nav-item group-audience" role="presentation">
                                        <button class="nav-link" id="group-tab" data-bs-toggle="tab" data-bs-target="#group-tab-pane" type="button" role="tab" aria-controls="group-tab-pane" aria-selected="false"><i class="las la-users"></i> <?php echo e(translate('Group Audience')); ?></button>
                                    </li>
                                    <li class="nav-item import-file" role="presentation">
                                        <button class="nav-link" id="file-tab" data-bs-toggle="tab" data-bs-target="#file-tab-pane" type="button" role="tab" aria-controls="file-tab-pane" aria-selected="false"><i class="las la-file-import"></i> <?php echo e(translate('Import File')); ?></button>
                                    </li>
                                </ul>

                                <div class="tab-content" id="myTabContent">
                                    <div class="tab-pane fade show active" id="single-tab-pane" role="tabpanel" aria-labelledby="single-tab" tabindex="0">
                                            <div class="form-item">
                                                <label for="number" class="form-label"> <?php echo e(translate('Single Input')); ?></label>
                                                <input type="number" class="form-control" value="<?php echo e(old('number')); ?>" name="number" id="number" placeholder="<?php echo e(translate('Enter with country code ')); ?><?php echo e($general->country_code); ?><?php echo e(translate('XXXXXXXXX')); ?>" aria-label="number" aria-describedby="basic-addon11">
                                                <div class="form-text"><?php echo e(translate('Put single or search from save file')); ?></div>
                                            </div>
                                    </div>

                                    <div class="tab-pane fade" id="group-tab-pane" role="tabpanel" aria-labelledby="group-tab" tabindex="0">
                                        <div class="form-item">
                                            <label class="form-label" for="group_id"><?php echo e(translate('From Group')); ?></label>
                                            <select class="form-select keywords" name="group_id[]" id="group_id" multiple="multiple">
                                                <option value="" disabled=""><?php echo e(translate('Select One')); ?></option>
                                                <?php $__currentLoopData = $groups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $group): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option <?php if(old("group_id")): ?><?php echo e((in_array($file->group_id, old("group_id")) ? "selected":"")); ?> <?php endif; ?> value="<?php echo e($group->id); ?>"><?php echo e($group->name); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                            <div class="form-text">
                                                <?php echo e(translate('Can be select single or multiple group')); ?>

                                            </div>
                                        </div>
                                    </div>

                                    <div class="tab-pane fade" id="file-tab-pane" role="tabpanel" aria-labelledby="file-tab" tabindex="0">
                                        <div class="form-item">
                                            <label class="form-label" for="file"><?php echo e(translate('Import File')); ?> <span id="contact_file_name"></span></label>
                                            <div class="upload-filed">
                                                <input type="file" name="file" id="file"/>
                                                
                                                <label for="file">
                                                    <div class="d-flex align-items-center gap-3">
                                                    <span class="upload-drop-file">
                                                        <svg xmlns="http://www.w3.org/2000/svg" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink"x="0" y="0" viewBox="0 0 128 128" style="enable-background:new 0 0 512 512" xml:space="preserve" class=""><g><path fill="#f6f0ff" d="M99.091 84.317a22.6 22.6 0 1 0-4.709-44.708 31.448 31.448 0 0 0-60.764 0 22.6 22.6 0 1 0-4.71 44.708z" opacity="1" data-original="#f6f0ff" class=""></path><circle cx="64" cy="84.317" r="27.403" fill="#6009f0" opacity="1" data-original="#6009f0" class=""></circle><g fill="#f6f0ff"><path d="M59.053 80.798v12.926h9.894V80.798h7.705L64 68.146 51.348 80.798zM68.947 102.238h-9.894a1.75 1.75 0 0 1 0-3.5h9.894a1.75 1.75 0 0 1 0 3.5z" fill="#f6f0ff" opacity="1" data-original="#f6f0ff" class=""></path></g></g></svg>
                                                    </span>
                                                    <span class="upload-browse"><?php echo e(translate("Upload File Here ")); ?></span>
                                                    </div>
                                                </label>
                                            </div>
                                            
                                            <div class="form-text mt-3">
                                                <?php echo e(translate('Download Sample: ')); ?>

                                                <a href="<?php echo e(route('demo.file.download', 'csv')); ?>" class="badge badge--primary"><i class="fa fa-download" aria-hidden="true"></i> <?php echo e(translate('csv')); ?>, </a>
                                                <a href="<?php echo e(route('demo.file.download', 'xlsx')); ?>" class="badge badge--primary"><i class="fa fa-download" aria-hidden="true"></i> <?php echo e(translate('xlsx')); ?></a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="form-wrapper">
                            <h6 class="form-wrapper-title"><?php echo e(translate('Schedule and message')); ?></h6>
                            <div class="row g-4">
                                <div class="col-md-6">
                                    <div class="form-item">
                                        <label class="form-label" for="smsTypeText"><?php echo e(translate('Select SMS Type')); ?> <sup class="text-danger">*</sup></label>
                                        <div class="radio-buttons-container message-type">
                                            <div class="radio-button">
                                                <input class="radio-button-input" <?php echo e(old("sms_type") == "plain" ?'checked' :""); ?> type="radio" name="sms_type" id="smsTypeText" value="plain" checked="">
                                                <label for="smsTypeText" class="radio-button-label">
                                                    <span class="radio-button-custom"></span>
                                                    <?php echo e(translate('Text')); ?>

                                                </label>
                                            </div>

                                            <div class="radio-button">
                                                <input  class="radio-button-input" <?php echo e(old("sms_type") == "unicode" ?'checked' :""); ?> type="radio" name="sms_type" id="smsTypeUnicode" value="unicode">
                                                <label for="smsTypeUnicode" class="radio-button-label">
                                                    <span class="radio-button-custom"></span>
                                                    <?php echo e(translate('Unicode')); ?>

                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-item">
                                        <label for="schedule-date" class="form-label"><?php echo e(translate('Schedule Date')); ?></label>
						                <input type="datetime-local" value ="<?php echo e(old('schedule_date')); ?>" name="schedule_date" id="schedule-date" class="form-control schedule-date">
                                    </div>
                                </div>

                                <div class="col schedule"></div>

                                <div class="col-12">
                                    <div class="form-item">
                                        <label class="form-label" for="message"><?php echo e(translate('Write Message')); ?> <sup class="text-danger">*</sup></label>
                                        <div class="speech-to-text" id="messageBox">
                                            <textarea class="form-control message" name="message" id="message" placeholder="<?php echo e(translate('Enter SMS Content &  For Mention Name Use ')); ?><?php echo "{{". 'name' ."}}"  ?>" aria-describedby="text-to-speech-icon"><?php echo e(session()->get('old_sms_message')); ?></textarea>
                                            <span class="voice-icon" id="text-to-speech-icon">
                                                <i class='fa fa-microphone text-to-speech-toggle'></i>
                                            </span>
                                        </div>

                                        <div class="mt-4 d-flex align-items-center justify-content-md-between justify-content-start flex-wrap gap-3">
                                            <div class="text-end message--word-count"></div>
                                            <a href="javascript:void(0)" class="i-btn info--btn btn--sm" data-bs-toggle="modal" data-bs-target="#template-data"><?php echo e(translate('Use Template')); ?></a>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </div>

                        <div>
                            <button type="submit" class="i-btn primary--btn btn--lg">
                                <?php echo e(translate("Submit")); ?>

                            </button>
                        </div>
                    </div>

                    <div class="note-container col-xl-3 order-xl-2 order-1 d-xl-block d-none">
                        <div class="note">
                            <h6><?php echo e(translate('Suggestions Note')); ?></h6>
                            <div class="note-body">
                                <p class="single-audience-note note-message"><?php echo e(translate("By selecting the 'Single Audience' input field, you can enter a valid phone number with a country code (For Example: $general->country_code xxxxxxxxxx). In order to send or schedule an SMS, continue filling up the rest of the form. ")); ?></p>
                                <p class="d-none group-audience-note note-message"><?php echo e(translate("By selecting the 'Group Audience' input field, You can choose your personal Text Phonebook group to send or schedule messages to all of the group's contacts.")); ?></p>
                                <p class="d-none import-file-note note-message"><?php echo e(translate("By selecting the 'Import File' input field, You can upload your local .csv or .xlsv files from your machine and send or schedule messages to those contacts")); ?></p>
                                <p class="d-none schedule-date-note note-message"><?php echo e(translate("By selecting the 'Schedule Date' input field, You can pick date and type to send a message according to that schedule")); ?></p>
                                <p class="d-none message-note note-message"><?php echo e(translate("You can either type your message or click the 'mic' icon to use the text to speech feature. By using the ")); ?><?php echo "{{". 'name' ."}}"  ?> <?php echo e(translate(" variable you can mention the name for that contact. But with 'Single Audience' selected only their number will pass by that variable.")); ?></p>
                                <p class="d-none message-type-note note-message"><?php echo e(translate("If you select the 'Text' option $general->sms_word_text_count characters will be allocated for a single SMS. And if you select 'unicode' then $general->sms_word_unicode_count characters will be allocated for each SMS.")); ?></p>
                                <p class="d-none select-sms-gateway-note note-message"><?php echo e(translate("By this option you'll be able to select a specific gateway by which this SMS will be sent. If none are selected then the default gateway which you have selected within your gateway list will be used to send this SMS.")); ?></p>
                            </div>
                        </div>
                        <?php if($general->sms_gateway == 1): ?>
                            <div class="form-wrapper select-sms-gateway mt-3">
                                <h6 class="form-wrapper-title" title="<?php echo e(translate('If left unselected then the default gateway will be selected')); ?>"><?php echo e(translate('Select Gateway')); ?></h6>
                                <div class="sms-gateway">
                                    <label for="repeat-time" class="form-label"><?php echo e(translate('Sms Gateway Type')); ?> </label>
                                    <select class="form-select repeat-scale sms_gateway_type" name="gateway_type" id="gateway_type">
                                        <option selected value=""><?php echo e(translate('-- Choose One --')); ?></option>
                                        <?php $__currentLoopData = $credentials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $credential): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($credential->gateway_code); ?>"><?php echo e(strtoupper($credential->name)); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <div class="sms-gateway sms-gateways mt-4 d-none">
                                    <label for="gatewwayId" class="form-label"><?php echo e(translate('Sms Gateway')); ?> <sup class="text-danger">*</sup></label>
                                    <select class="form-control gateway-collect" name="gateway_id" id="gatewwayId"></select>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </form>
        </div>
    </div>
</section>

<div class="modal fade" id="template-data" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
			<div class="modal-header">
                <h5 class="modal-title"><?php echo e(translate('SMS Template')); ?></h5>
                <button type="button" class="i-btn bg--lite--danger text--danger btn--sm" data-bs-dismiss="modal"> <i class="las la-times"></i></button>
			</div>
            <div class="modal-body">
            	<div class="form-item">
					<label for="template" class="form-label"><?php echo e(translate('Select Template')); ?> <sup class="text--danger">*</sup></label>
					<select class="form-select" name="template" id="template" required>
						<option value="" disabled="" selected=""><?php echo e(translate('Select One')); ?></option>
						<?php $__currentLoopData = $templates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $template): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
							<option value="<?php echo e($template->message); ?>"><?php echo e($template->name); ?></option>
						<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
					</select>
            	</div>
            </div>

			<div class="modal-footer">
				<button type="button" class="i-btn danger--btn btn--md" data-bs-dismiss="modal">Close</button>
			</div>

        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php $__env->startPush('script-push'); ?>
	<script>
		(function($){
			"use strict";
			$('.keywords').select2({
				tags: true,
				tokenSeparators: [',']
			});

            //Contact File Input Details
            $("#file").change(function() {
                var contact_file = this.files[0];
                var file_name = "<?php echo e(translate('Selected: ')); ?><p class='badge badge--primary'>"+ contact_file.name +"</p>";
                $("#contact_file_name").html(file_name);

            })

            let wordLength = <?php echo e($general->sms_word_text_count); ?>;

            $('input[type=radio][name=sms_type]').on('change', function(){
				if(this.value == "unicode"){
					wordLength = <?php echo e($general->sms_word_unicode_count); ?>;
				}else{
					wordLength = <?php echo e($general->sms_word_text_count); ?>;
				}
			});
            
			$('input[type=datetime-local][name=schedule_date]').on('change', function(){

                if($(this).val()){
                    const html = `
                    <input hidden type="number" value ="2" name="schedule" id="schedule" class="form-control">`;
                    $('.schedule').append(html);
                }else{
                    const html = `
                    <input hidden type="number" value ="1" name="schedule" id="schedule" class="form-control">`;
                    $('.schedule').append(html);
                }
			});


			$('select[name=template]').on('change', function(){
                const character = $(this).val();
                $('textarea[name=message]').val(character);
				$('#template-data').modal('toggle');
			});

			$(`textarea[name=message]`).on('keyup', function(event) {
				var character = $(this).val();
				var word = character.split(" ");
				var sms = 1;
				if (character.length > wordLength) {
					sms = Math.ceil(character.length / wordLength);
				}
				if (character.length > 0) {
					$(".message--word-count").html(`
						<span class="text--success character">${character.length}</span> <?php echo e(translate('Character')); ?> |
						<span class="text--success word">${word.length}</span> <?php echo e(translate('Words')); ?> |
						<span class="text--success word">${sms}</span> <?php echo e(translate('SMS')); ?> (${wordLength} Char./SMS)`);
				}else{
					$(".message--word-count").empty()
				}
			});

			var t = window.SpeechRecognition || window.webkitSpeechRecognition,
				e = document.querySelectorAll(".speech-to-text");
			if (null != t && null != e) {
				var n = new t;
				var e = !1;
				$('#text-to-speech-icon').on('click',function () {
					var messageBox = document.getElementById('messageBox');
					messageBox.querySelector(".form-control").focus(), n.onspeechstart = function() {
						e = !0
					}, !1 == e && n.start(), n.onerror = function() {
						e = !1
					}, n.onresult = function(e) {
						messageBox.querySelector(".form-control").value = e.results[0][0].transcript
					}, n.onspeechend = function() {
						e = !1, n.stop()
					}
				});
			}

			const inputNumber = document.getElementById('number');
			inputNumber.addEventListener('keyup', function() {
			const cleanedValue = this.value.replace(/[^\d.-]/g, '');
			this.value = cleanedValue;
			});


            // Note
            const infoNoteBtn = document.querySelector(".info-note-btn");
            infoNoteBtn.addEventListener("click", ()=>{
                    const noteContainer = document.querySelector(".note-container");
                    noteContainer.classList.toggle("d-none");
            });


            $('.sms_gateway_type').change(function () {
                
                var selectedType = $(this).val();
                $('.sms-gateways').removeClass('d-none');
                $('.sms-gateways').addClass('d-block');

                if(selectedType == ''){
                    $('.sms-gateways').addClass('d-none');
                }
                $.ajax({
                    type: 'GET',
                    url: "<?php echo e(route('admin.gateway.select2')); ?>",
                    data:{
                        'type' : selectedType,
                    },
                    dataType: 'json',
                    success: function (data) {  
                        
                        $('.gateway-collect').empty();

                        $.each(data, function (key, value) {
                            var select   = $('<option value="' + value.id + '">' + value.name + '</option>');
                            $('.gateway-collect').append(select);
                        });
                    },
                    error: function (xhr, status, error) {
                        console.log(error);
                    }
                });
            });


		})(jQuery);
	</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\laragon\www\xsender\src\resources\views/admin/sms/create.blade.php ENDPATH**/ ?>